; InkSpector Assembler ZX Spectrum 128K Example
; Mark Incley
; 03.01.2010
;
		TARGET	ZXSPECTRUM128
		EXECUTE IMMEDIATE

		ORG 	$8000

Start:		di
		ld	sp,Start
		ld	a,1
		call	PageRAM

		ld	hl,ColouredStripes
		ld	de,$5800
		ld	bc,32*24
		ldir

.end:		jr	.end


PageRAM:	ld	c,a
		ld      a,(0x5b5c)      ; previous value of port
		and     0xf8
		or      c               ; select bank c
		ld      bc,0x7ffd
		ld      (0x5b5c),a
		out     (c),a
		ret

; Put some coloured stripes in bank 1

; BANK controls which memory page the code is assembled into. For a Spectrum it also
; sets the ORG address to $C000

		BANK 	1
		ASSERT 	$ == $C000

col		DEFL 	0

ColouredStripes:REPT 	24
 		ds	32,8*(col & 7)
col		DEFL	col+1
		ENDR

		ASSERT 	$ == ColouredStripes + 32 * 24

		SAVETAPE	"example_128k.pzx"

		END 	Start
