-- batch_snapshot_to_scr.lua
-- Produce .scr files from a folder containing snapshot files
-- Mark Incley 17.02.2025

srcfolder = [[C:\my_snapshots_folder]]
-- We're only interested in loading snapshot types (i.e. not screenshots, tapes, etc.)
for inpath in dir(srcfolder,{include_classes={inks.file_class.snapshot}}) do
	lresult = inks.load(inpath)
	if lresult == inks.status.ok then
		-- Save the display as contained in the snapshot out as a .scr file
		outpath = inks.replace_extension(inpath, ".scr")
		inks.save(outpath)
	end
end
