-- queue_recordings.lua
-- Queue up multiple RZX recordings for playback
-- Mark Incley 27.12.2020

files_to_play={}

function queue_path(path)
	table.insert(files_to_play, {n=#files_to_play+1, path=path})
end

function queue_first_match(pattern)
	local results = inks.find_in_library(pattern)
	if #results > 0 then
		-- Queue the first matching result
		queue_path(results[1])
	end
end

-- Perform a quick test to ensure we're running a recent enough Inkspector
if not inks.is_playing_recording then
	inks.stop_script("Please run this script under a later version of Inkspector")
end

-- If you want to queue up a specific file...
queue_path([[c:\temp\jungle.rzx]])
queue_path([[c:\temp\manic.rzx]])

-- If you want to queue up the .rzx files inside a folder (including any sub-folders)
local folder_to_include <const> = [[c:\temp\rzx]]
if inks.is_directory(folder_to_include) then
	for path in dir(folder_to_include, {include_types={inks.file_type.rzx}}) do
		queue_path(path)
	end
end

-- But since I don't know what your HD looks like, we'll do a library search for recordings to play...
queue_first_match("jungle ext:rzx")
queue_first_match("styx ext:rzx")
queue_first_match("monty ext:rzx")
queue_first_match("stonkers ext:rzx")

if #files_to_play==0 then
	inks.stop_script("Unable to find any RZX recordings to play. Are your archive folders set up correctly?")
end

-- Print the playlist to the message window
print(#files_to_play.." files have been queued up to play.")
if #files_to_play <= 20 then
	print("The playlist is:")
	for k,v in pairs(files_to_play) do
		print("  "..v.path)
	end
else
	print("Not showing the playlist as it's too long!")
end

-- Now enter a loop to play them all
for k,v in pairs(files_to_play) do
	local path = v.path
	local result = inks.load(path)

	if result == inks.status.ok then
		inks.add_message_for_user("Playing "..v.n.." of "..#files_to_play..": "..path)
	else
		inks.add_message_for_user("Unable to load: "..path)
	end

	-- Wait for the recording to finish playing
	-- NB if the recording failed to load it won't be playing a recording, so will exit this loop
	while inks.is_playing_recording() do
		inks.dreamysleepynightiesnoozysnooze(1)	-- Wait for a second before checking again whether we've finished playing
	end
end
