; InkSpector Assembler Jupiter ACE Example
; Mark Incley
; 27.08.2023
;
; NB when setting the target to ACE, the ORG address is set to the byte after the
; system variables (i.e. ORG $3CF0).
;
; The address may be be overridden if necessary with the usual ORG directive.

		TARGET		ACE
		IMPORT		SYSVARS

		SAVESNAP	"example_ace.ace"
		SAVETAPE	"example_ace.tap"
		TAPEPROGNAME	"p"

		DEFINE Video	$2400

msg		db	"Hello from Inkspector ",__INKSPECTOR__,"!"
msgend 		EQU $

Start:		ld	hl,msg
		ld	de,Video
		ld	bc,msgend-msg
		ldir

		; The OS will probably be in a poor state as we've overwritten the first word
		; so just loop endlessly
.loop		jr	.loop

		END 	Start

