; InkSpector Assembler ZX80 Example
; Mark Incley
; 12.06.2022
;
; NB when setting the target to ZX80 (or ZX81), the ORG address is set automatically
; to the address within a REM statement where the machine code will be deposited.
; The address could change slightly between releases of Inkspector, so don't assume it
; will be placed at a specific address. Also different TAPELOADEREXEC settings may move
; the address.
;
; The address may be be overridden if necessary with the usual ORG directive.

		TARGET		ZX80
		TAPELOADEREXEC 	PRINT	; Execute the code using a PRINT USR statement so the value of HL is displayed on return
		IMPORT 		SYSVARS
		SAVELISTING

		DEFINE		EOM	$76

Start:		ld	hl,42	; Return a magic value
		ret

		SAVETAPE	"example_zx80.80"

; DEFNM (Define Native Messsage) converts from ASCII to the target machine's native character set.
msg:		DEFNM		"HELLO FROM INKSPECTOR.",EOM

		END 	Start
