; InkSpector Assembler ZX81 Example
; Mark Incley
; 12.06.2022
;
; NB when setting the target to ZX81 (or ZX80), the ORG address is set automatically
; to the address within a REM statement where the machine code will be deposited.
; The address could change slightly between releases of Inkspector, so don't assume it
; will be placed at a specific address. Also different TAPELOADEREXEC settings may move
; the address.
;
; The address may be be overridden if necessary with the usual ORG directive.

		TARGET	ZX81
		TAPELOADEREXEC PRINT	; Execute the code using a PRINT USR statement
		SAVELISTING

; $43 is the first gap in the ZX81 character set, so we'll use that as our end of message byte.
		DEFINE		EOM	$43

Start:		ld	hl,msg
.loop:		ld	a,(hl)
		cp	EOM
		ret	z

		rst	$10
		inc	hl
		jr	.loop

		SAVETAPE	"example_zx81.p"
		;SAVETAPE	"example_zx81.81"
		;SAVETAPE	"example_zx81.p81"

; DEFNM (Define Native Messsage) converts from ASCII to the target machine's native character set.
msg:		DEFNM		"HELLO FROM INKSPECTOR.",EOM

		END 	Start
